
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/lonerseva.zip" ),
}
local prefabs = {}


local start_inv = {
"loner_seva",
"scroll",
}




local fn = function(inst)

local function sanityfn(inst)
local x,y,z = inst.Transform:GetWorldPosition()
local delta = 0
local max_rad = 10
local ents = TheSim:FindEntities(x,y,z, max_rad, nil, nil, {"bandit", "USS"})
    for k,v in pairs(ents) do 
if not (v.components.health and v.components.health:IsDead()) then
local sz = -TUNING.SANITYAURA_MED
local rad = 10
sz = sz * ( math.min(max_rad, rad) / max_rad )
local distsq = inst:GetDistanceSqToInst(v)
delta = delta + sz/math.max(1, distsq)
    end
    end
    
    return delta
end

local loner_seva = Ingredient( "loner_seva", 1)
loner_seva.atlas = "images/inventoryimages/loner_seva.xml"
local armor_device = Recipe("loner_seva", { Ingredient("goldnugget", 17), loner_seva }, RECIPETABS.REFINE, {REFINE=0})
armor_device.atlas = "images/inventoryimages/loner_seva.xml"


inst.components.sanity.custom_rate_fn = sanityfn

--inst:AddComponent("petleash")
	--inst.components.petleash:SetMaxPets(4)
	inst.soundsname = "loner"
	inst:AddTag("loner")
	inst:AddTag("stalker")
	inst.MiniMapEntity:SetIcon( "lonerseva.tex" )
	
	inst.components.sanity.neg_aura_mult = 0.9
	
	inst.components.builder.science_bonus = 1
	
	-- Stats	
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(175)
	inst.components.sanity:SetMax(200)

end

return MakePlayerCharacter("lonerseva", prefabs, assets, fn, start_inv)
